Attribute VB_Name = "CtrlCard"
'********************** Motion Control Module ********************

'********************************************************
Public result As Long      'Return Value

Const MAXAXIS = 4           'The maximum number of axes

Public Const EM_GETLINECOUNT = &HBA  'Head office to obtain the number of text boxes
Public Const EM_GETLINE = &HC4       'Get a text box to specify the contents of the line
Public Const EM_LINEINDEX = &HBB     'Access to the specified line ( or : -1,0 said cursor line) the first character position in the text (in bytes that )"
Public Const EM_LINELENGTH = &HC1    'Access to the specified line ( or : -1,0 said cursor line) the first character position in the text (in bytes that

Public Const DATA_SECTION = 524288   'Block download size limit of 512K

Public totalLength As Long           'G code file, the total number of bytes
Public m_nSendLen As Long            'When the block mode of data processing code size sent G
Public m_CountStart As Long          'Start trekking No."
Public m_CountEnd As Long            'No. termination trekking
Public gFileCode As String           'Block in the G file


Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long

Declare Function SetPixelV Lib "gdi32" (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long, ByVal crColor As Long) As Long


Public Function Init_Card(ByVal devnum As Long) As Long
       
   
   If (devnum = 0) Then
   
       For i = 1 To MAXAXIS
       
       result = adt8840a_set_command_pos(devnum, i, 0)         'Logical position counter clear
       
       adt8840a_set_actual_pos devnum, i, 0                    'Real -bit position counter clear
       
       adt8840a_set_startv devnum, i, 1000                     'Set the initial velocity
    
       adt8840a_set_speed devnum, i, 2000                      'Set drive speed
       
       adt8840a_set_acc devnum, i, 625                         'Set Acceleration
     
       Next i
       
       adt8840a_clear_buff_depth devnum      'Empty the cache
              
       adt8840a_stop_all devnum              'Immediately stop all axes
       
       adt8840a_set_buff_mode devnum, 0      'Close the software cache
       
       adt8840a_set_speed_mode devnum, 0     'Speed of the free mode
       
       Uart_show devnum, 0                   'Close serial port
       
       Init_Card = 1
   Else
       Init_Card = -1
    
   End If
       
End Function


'**********************Set Speed Module***********************

'*********************************************************
Public Function Setup_Speed(ByVal axis As Long, ByVal startv As Long, ByVal speed As Long, ByVal add As Long) As Long

        If (startv - speed >= 0) Then
        
            result = adt8840a_set_startv(devnum, axis, startv)
        
            adt8840a_set_speed devnum, axis, startv
                        
        Else
        
            result = adt8840a_set_startv(devnum, axis, startv)
        
            adt8840a_set_speed devnum, axis, speed
        
            adt8840a_set_acc devnum, axis, add
            
            
        End If
       
End Function

'*********************Single -driven functions**********************

'*******************************************************
Public Function Axis_Pmove(ByVal axis As Long, ByVal pulse As Long) As Long
    
    result = adt8840a_pmove(devnum, axis, pulse)
    
    Axis_Pmove = Rresult
    
End Function

'****************************Continuous drive function***************************
'*******************************************************************
Public Function Axis_Cmove(ByVal axis As Long, ByVal value As Long) As Long

    result = adt8840a_continue_move(devnum, axis, value)
    
    Axis_Cmove = result

End Function

'*******************Arbitrary two-axis interpolation function********************
'*******************************************************
Public Function Interp_Move2(ByVal axis1 As Long, ByVal axis2 As Long, ByVal pulse1 As Long, ByVal pulse2 As Long) As Long

    result = adt8840a_inp_move2(devnum, axis1, axis2, pulse1, pulse2)
    
    Interp_Move2 = result
    
End Function

'*******************Arbitrary axis interpolation function********************
'*******************************************************

Public Function Interp_Move3(ByVal axis1 As Long, ByVal axis2 As Long, ByVal axis3 As Long, ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long) As Long

    result = adt8840a_inp_move3(devnum, axis1, axis2, axis3, pulse1, pulse2, pulse3)
    
    Interp_Move3 = result
    
End Function


'*******************Four-axis interpolation function********************

'*******************************************************
Public Function Interp_Move4(ByVal pulse1 As Long, ByVal pulse2 As Long, ByVal pulse3 As Long, ByVal pulse4 As Long) As Long
    
    result = adt8840a_inp_move4(devnum, pulse1, pulse2, pulse3, pulse4)
    
    Interp_Move4 = result
    
End Function

'*******************Stop driving function********************

'*******************************************************
Public Function StopRun(ByVal axis As Long, ByVal mode As Long) As Long

    If mode = 0 Then
        
        result = adt8840a_sudden_stop(devnum, axis)
        
    Else
    
        result = adt8840a_dec_stop(devnum, axis)
    
    End If

End Function

'*******************Set Position function********************

'*******************************************************
Public Function Setup_Pos(ByVal axis As Long, ByVal pos As Long, ByVal mode As Long) As Long

    If mode = 0 Then
    
        result = adt8840a_set_command_pos(devnum, axis, pos)
        
    Else
    
        result = adt8840a_set_actual_pos(devnum, axis, pos)
        
    End If
    
End Function

'*******************Access to sports information function*******************
'*******************************************************
Public Function Get_CurrentInf(ByVal axis As Long, LogPos As Long, ActPos As Long, speed As Long) As Long

    result = adt8840a_get_command_pos(devnum, axis, LogPos)
    
    adt8840a_get_actual_pos devnum, axis, ActPos
    
    adt8840a_get_speed devnum, axis, speed
    
    Get_CurrentInf = result
    
End Function

'*******************State function for motion********************

'*******************************************************
Public Function Get_MoveStatus(ByVal axis As Long, value As Long, ByVal mode As Long) As Long

    If mode = 0 Then
    
        GetMove_Status = adt8840a_get_status(devnum, axis, value)
        
    Else
    
        GetMove_Status = adt8840a_get_inp_status(devnum, value)
        
    End If
    
End Function

'***********************Read input*******************************
'****************************************************************
Public Function Read_Input(ByVal number As Long, value As Long) As Long
    
    Read_Input = adt8840a_read_bit(devnum, number, value)
    
End Function

'********************Output a single point of function******************************
'****************************************************************
Public Function Write_Output(ByVal number As Long, ByVal value As Long) As Long

    Write_Output = adt8840a_write_bit(devnum, number, value)

End Function
'********************Set the pulse output mode**********************

Public Function Setup_PulseMode(ByVal axis As Long, ByVal value As Long) As Long

    Setup_PulseMode = adt8840a_set_pulse_mode(devnum, axis, value, 0, 0)
    
End Function


'  *********************************************************
Public Function Setup_LimitMode(ByVal axis As Long, ByVal value1 As Long, ByVal value2 As Long, ByVal logic As Long) As Long

    Setup_LimitMode = adt8840a_set_limit_mode(devnum, axis, value1, value2, logic)
    
End Function

'********************Set the limit signal mode**********************
'  *********************************************************
Public Function Setup_Stop0Mode(ByVal axis As Long, ByVal value As Long, ByVal logic As Long) As Long

    Setup_Stop0Mode = adt8840a_set_stop0_mode(devnum, axis, value, logic)
    
End Function
'********************Set stop1 signaling**********************
'  *********************************************************
Public Function Setup_Stop1Mode(ByVal axis As Long, ByVal value As Long, ByVal logic As Long) As Long

    Setup_Stop1Mode = adt8840a_set_stop1_mode(devnum, axis, value, logic)
    
End Function

'/*****************Motion information for all axes******************************
'  *********************************************************
Public Function Get_AxisInfo(ByVal dev_num As Long, ByRef LogPos() As Long, ByRef ActPos() As Long, ByRef speed() As Long) As Long

    adt8840a_all_command_pos devnum, LogPos(0)
    adt8840a_all_actual_pos devnum, ActPos(0)
    Get_AxisInfo = adt8840a_all_speed(devnum, speed(0))
    
End Function

'*****************For the text box contents , length*********************************************************
'  *******************************************************************************************
Public Function Get_TextInfo(ByVal hwnd As Long, ByVal countStart As Long, ByVal countEnd As Long, ByVal g_code As String) As Long
    Dim str() As Byte
    Dim length As Long
    Dim lineCount As Long
    Dim result As Long
    lineCount = SendMessage(hwnd, EM_GETLINECOUNT, 0, 0)
     For i = countStart To countEnd
     
        If i = countStart Then
          
          If (i = lineCount - 1) Then
            length = totalLength - SendMessage(hwnd, EM_LINEINDEX, lineCount - 1, 0)
            ReDim str(length)
            str(1) = 1
            SendMessage hwnd, EM_GETLINE, i, str(0)
            gFileCode = StrConv(str, vbUnicode)
            Exit For
            
          Else
            length = SendMessage(hwnd, EM_LINEINDEX, i + 1, 0) - SendMessage(hwnd, EM_LINEINDEX, i, 0)
            ReDim str(length - 1)
            str(1) = 1
            SendMessage hwnd, EM_GETLINE, i, str(0)
            g_code = StrConv(str, vbUnicode)
          
          End If
          
       Else
          
          If i = countEnd Then
            If (i = lineCount - 1) Then
               length = totalLength - SendMessage(hwnd, EM_LINEINDEX, lineCount - 1, 0)
               ReDim str(length)
               str(1) = 1
               SendMessage hwnd, EM_GETLINE, i, str(0)
               gFileCode = g_code & StrConv(str, vbUnicode)
            Else
               length = SendMessage(hwnd, EM_LINEINDEX, i + 1, 0) - SendMessage(hwnd, EM_LINEINDEX, i, 0)
               ReDim str(length - 1)
               str(1) = 1
               SendMessage hwnd, EM_GETLINE, i, str(0)
               gFileCode = g_code & StrConv(str, vbUnicode)
            End If
          
          Else
              length = SendMessage(hwnd, EM_LINEINDEX, i + 1, 0) - SendMessage(hwnd, EM_LINEINDEX, i, 0) 'ȡָг
              ReDim str(length - 1)
              str(1) = 1
              SendMessage hwnd, EM_GETLINE, i, str(0)
              g_code = g_code & StrConv(str, vbUnicode)
        
          End If
          
      End If
        
    Next i
        
    Get_TextInfo = Len(gFileCode)
    
End Function





